/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl.pool;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.pool.Endpoint;
import io.vertx.core.net.impl.pool.EndpointProvider;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ConnectionManager<K, C> {
    private final Map<K, Endpoint<C>> endpointMap = new ConcurrentHashMap<K, Endpoint<C>>();

    public void forEach(Consumer<Endpoint<C>> consumer) {
        this.endpointMap.values().forEach(consumer);
    }

    public void getConnection(ContextInternal ctx, K key, EndpointProvider<C> provider, Handler<AsyncResult<C>> handler) {
        this.getConnection(ctx, key, provider, 0L, handler);
    }

    public void getConnection(ContextInternal ctx, K key, EndpointProvider<C> provider, long timeout2, Handler<AsyncResult<C>> handler) {
        Endpoint endpoint;
        Runnable dispose = () -> this.endpointMap.remove(key);
        while (!(endpoint = this.endpointMap.computeIfAbsent(key, k -> provider.create(ctx, dispose))).getConnection(ctx, timeout2, handler)) {
        }
    }

    public void close() {
        for (Endpoint<C> conn : this.endpointMap.values()) {
            conn.close();
        }
    }
}

