/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.yaml;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlProcessor
implements ConfigProcessor {
    private static final LoaderOptions DEFAULT_OPTIONS = new LoaderOptions();

    @Override
    public String name() {
        return "yaml";
    }

    @Override
    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        if (input.length() == 0) {
            return ((ContextInternal)vertx.getOrCreateContext()).succeededFuture(new JsonObject());
        }
        return vertx.executeBlocking(promise -> {
            try {
                Yaml yamlMapper = new Yaml(new SafeConstructor(DEFAULT_OPTIONS));
                Map doc = (Map)yamlMapper.load(input.toString(StandardCharsets.UTF_8));
                promise.complete(YamlProcessor.jsonify(doc));
            }
            catch (ClassCastException e) {
                promise.fail(new DecodeException("Failed to decode YAML", e));
            }
            catch (RuntimeException e) {
                promise.fail(e);
            }
        });
    }

    private static JsonObject jsonify(Map<Object, Object> yaml) {
        if (yaml == null) {
            return null;
        }
        JsonObject json = new JsonObject();
        for (Map.Entry<Object, Object> kv : yaml.entrySet()) {
            Object value = kv.getValue();
            if (value instanceof Map) {
                value = YamlProcessor.jsonify((Map)value);
            }
            if (value instanceof Date) {
                value = ((Date)value).toInstant();
            }
            json.put(kv.getKey().toString(), value);
        }
        return json;
    }
}

