/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.FluxMapFuseable;
import io.micrometer.shaded.reactor.core.publisher.InternalMonoOperator;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import java.util.Objects;
import java.util.function.Function;

final class MonoMapFuseable<T, R>
extends InternalMonoOperator<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    MonoMapFuseable(Mono<? extends T> source2, Function<? super T, ? extends R> mapper) {
        super(source2);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)actual;
            return new FluxMapFuseable.MapFuseableConditionalSubscriber<T, R>(cs, this.mapper);
        }
        return new FluxMapFuseable.MapFuseableSubscriber<T, R>(actual, this.mapper);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

