/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class TcpWindowScaleOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -1755743386204601523L;
    private final TcpOptionKind kind = TcpOptionKind.WINDOW_SCALE;
    private final byte length;
    private final byte shiftCount;

    public static TcpWindowScaleOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new TcpWindowScaleOption(rawData, offset, length);
    }

    private TcpWindowScaleOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 3) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("The raw data length must be more than 2. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        if (rawData[offset] != (Byte)this.kind.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The kind must be: ").append(this.kind.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = rawData[1 + offset];
        if (this.length != 3) {
            throw new IllegalRawDataException("The value of length field must be 3 but: " + this.length);
        }
        this.shiftCount = rawData[2 + offset];
    }

    private TcpWindowScaleOption(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder: " + builder);
        }
        this.shiftCount = builder.shiftCount;
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte getShiftCount() {
        return this.shiftCount;
    }

    public int getShiftCountAsInt() {
        return 0xFF & this.shiftCount;
    }

    @Override
    public int length() {
        return 3;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        rawData[2] = this.shiftCount;
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind);
        sb.append("] [Length: ").append(this.getLengthAsInt());
        sb.append(" bytes] [Shift Count: ").append(this.getShiftCountAsInt());
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TcpWindowScaleOption other = (TcpWindowScaleOption)obj;
        return this.length == other.length && this.shiftCount == other.shiftCount;
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 31 * result2 + this.length;
        result2 = 31 * result2 + this.shiftCount;
        return result2;
    }

    public static final class Builder
    implements LengthBuilder<TcpWindowScaleOption> {
        private byte length;
        private byte shiftCount;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(TcpWindowScaleOption option) {
            this.length = option.length;
            this.shiftCount = option.shiftCount;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder shiftCount(byte shiftCount) {
            this.shiftCount = shiftCount;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public TcpWindowScaleOption build() {
            return new TcpWindowScaleOption(this);
        }
    }
}

