/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi.tls;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslServerContext;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.vertx.core.spi.tls.DefaultJDKCipherSuite;
import io.vertx.core.spi.tls.SslContextFactory;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManagerFactory;

public class DefaultSslContextFactory
implements SslContextFactory {
    private final SslProvider sslProvider;
    private final boolean sslSessionCacheEnabled;
    private Set<String> enabledCipherSuites;
    private List<String> applicationProtocols;
    private boolean useAlpn;
    private ClientAuth clientAuth;
    private boolean forClient;
    private KeyManagerFactory kmf;
    private TrustManagerFactory tmf;

    public DefaultSslContextFactory(SslProvider sslProvider, boolean sslSessionCacheEnabled) {
        this.sslProvider = sslProvider;
        this.sslSessionCacheEnabled = sslSessionCacheEnabled;
    }

    @Override
    public SslContextFactory useAlpn(boolean useAlpn) {
        this.useAlpn = useAlpn;
        return this;
    }

    @Override
    public SslContextFactory clientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
        return this;
    }

    @Override
    public SslContextFactory forClient(boolean forClient) {
        this.forClient = forClient;
        return this;
    }

    @Override
    public SslContextFactory keyMananagerFactory(KeyManagerFactory kmf) {
        this.kmf = kmf;
        return this;
    }

    @Override
    public SslContextFactory trustManagerFactory(TrustManagerFactory tmf) {
        this.tmf = tmf;
        return this;
    }

    @Override
    public SslContext create() throws SSLException {
        return this.createContext(this.useAlpn, this.forClient, this.kmf, this.tmf);
    }

    @Override
    public SslContextFactory enabledCipherSuites(Set<String> enabledCipherSuites) {
        this.enabledCipherSuites = enabledCipherSuites;
        return this;
    }

    @Override
    public SslContextFactory applicationProtocols(List<String> applicationProtocols) {
        this.applicationProtocols = applicationProtocols;
        return this;
    }

    private SslContext createContext(boolean useAlpn, boolean client2, KeyManagerFactory kmf, TrustManagerFactory tmf) throws SSLException {
        SSLSessionContext sslSessionContext;
        SslContext ctx;
        SslContextBuilder builder;
        if (client2) {
            builder = SslContextBuilder.forClient();
            if (kmf != null) {
                builder.keyManager(kmf);
            }
        } else {
            builder = SslContextBuilder.forServer(kmf);
        }
        Collection<String> cipherSuites = this.enabledCipherSuites;
        switch (this.sslProvider) {
            case OPENSSL: {
                builder.sslProvider(SslProvider.OPENSSL);
                if (cipherSuites != null && !cipherSuites.isEmpty()) break;
                cipherSuites = OpenSsl.availableOpenSslCipherSuites();
                break;
            }
            case JDK: {
                builder.sslProvider(SslProvider.JDK);
                if (cipherSuites != null && !cipherSuites.isEmpty()) break;
                cipherSuites = DefaultJDKCipherSuite.get();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (tmf != null) {
            builder.trustManager(tmf);
        }
        if (cipherSuites != null && cipherSuites.size() > 0) {
            builder.ciphers(cipherSuites);
        }
        if (useAlpn && this.applicationProtocols != null && this.applicationProtocols.size() > 0) {
            ApplicationProtocolConfig.SelectedListenerFailureBehavior slfb;
            ApplicationProtocolConfig.SelectorFailureBehavior sfb;
            if (this.sslProvider == SslProvider.JDK) {
                sfb = ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT;
                slfb = ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT;
            } else {
                sfb = ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE;
                slfb = ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT;
            }
            builder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, sfb, slfb, (Iterable<String>)this.applicationProtocols));
        }
        if (this.clientAuth != null) {
            builder.clientAuth(this.clientAuth);
        }
        if ((ctx = builder.build()) instanceof OpenSslServerContext && (sslSessionContext = ctx.sessionContext()) instanceof OpenSslServerSessionContext) {
            ((OpenSslServerSessionContext)sslSessionContext).setSessionCacheEnabled(this.sslSessionCacheEnabled);
        }
        return ctx;
    }
}

