/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializableUtils {
    public static byte[] toBytes(Object o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromBytes(byte[] bytes, ObjectInputStreamFactory factory2) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (ObjectInputStream ois = factory2.create(bais);){
            Object object = ois.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private SerializableUtils() {
    }

    @FunctionalInterface
    public static interface ObjectInputStreamFactory {
        public ObjectInputStream create(ByteArrayInputStream var1) throws IOException;
    }
}

