/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.captain.ce.pipeline;

import io.netty.buffer.ByteBuf;
import io.sip3.captain.ce.domain.Packet;
import io.sip3.captain.ce.pipeline.Handler;
import io.sip3.captain.ce.pipeline.Ipv4Handler;
import io.sip3.captain.ce.pipeline.Ipv6Handler;
import io.sip3.commons.domain.payload.Encodable;
import io.sip3.commons.domain.payload.Payload;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/sip3/captain/ce/pipeline/EthernetHandler;", "Lio/sip3/captain/ce/pipeline/Handler;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lio/vertx/core/json/JsonObject;", "bulkOperationsEnabled", "", "(Lio/vertx/core/Vertx;Lio/vertx/core/json/JsonObject;Z)V", "ipv4Handler", "Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "getIpv4Handler", "()Lio/sip3/captain/ce/pipeline/Ipv4Handler;", "ipv4Handler$delegate", "Lkotlin/Lazy;", "ipv6Handler", "Lio/sip3/captain/ce/pipeline/Ipv6Handler;", "getIpv6Handler", "()Lio/sip3/captain/ce/pipeline/Ipv6Handler;", "ipv6Handler$delegate", "linuxCookedMode", "onPacket", "", "packet", "Lio/sip3/captain/ce/domain/Packet;", "readEthernetType", "", "buffer", "Lio/netty/buffer/ByteBuf;", "Companion", "sip3-captain-ce"})
public final class EthernetHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean linuxCookedMode;
    @NotNull
    private final Lazy ipv4Handler$delegate;
    @NotNull
    private final Lazy ipv6Handler$delegate;
    public static final int TYPE_IPV4 = 2048;
    public static final int TYPE_IPV6 = 34525;
    public static final int TYPE_802_1_Q = 33024;
    public static final int TYPE_802_1_AD = 34984;

    public EthernetHandler(@NotNull Vertx vertx, @NotNull JsonObject config2, boolean bulkOperationsEnabled) {
        Intrinsics.checkNotNullParameter(vertx, "vertx");
        Intrinsics.checkNotNullParameter(config2, "config");
        super(vertx, config2, bulkOperationsEnabled);
        Object object = config2.getJsonObject("pcap");
        if (object != null && (object = ((JsonObject)object).getBoolean("sll")) != null) {
            boolean it = (Boolean)object;
            boolean bl = false;
            this.linuxCookedMode = it;
        }
        this.ipv4Handler$delegate = LazyKt.lazy((Function0)new Function0<Ipv4Handler>(vertx, config2, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final Ipv4Handler invoke() {
                return new Ipv4Handler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        });
        this.ipv6Handler$delegate = LazyKt.lazy((Function0)new Function0<Ipv6Handler>(vertx, config2, bulkOperationsEnabled){
            final /* synthetic */ Vertx $vertx;
            final /* synthetic */ JsonObject $config;
            final /* synthetic */ boolean $bulkOperationsEnabled;
            {
                this.$vertx = $vertx;
                this.$config = $config;
                this.$bulkOperationsEnabled = $bulkOperationsEnabled;
                super(0);
            }

            @NotNull
            public final Ipv6Handler invoke() {
                return new Ipv6Handler(this.$vertx, this.$config, this.$bulkOperationsEnabled);
            }
        });
    }

    private final Ipv4Handler getIpv4Handler() {
        Lazy lazy = this.ipv4Handler$delegate;
        return (Ipv4Handler)lazy.getValue();
    }

    private final Ipv6Handler getIpv6Handler() {
        Lazy lazy = this.ipv6Handler$delegate;
        return (Ipv6Handler)lazy.getValue();
    }

    @Override
    public void onPacket(@NotNull Packet packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Payload payload = packet.getPayload();
        Intrinsics.checkNotNull(payload, "null cannot be cast to non-null type io.sip3.commons.domain.payload.Encodable");
        ByteBuf buffer = ((Encodable)payload).encode();
        buffer.skipBytes(12);
        if (this.linuxCookedMode) {
            buffer.skipBytes(2);
        }
        int etherType = this.readEthernetType(buffer);
        switch (etherType) {
            case 2048: {
                this.getIpv4Handler().handle(packet);
                break;
            }
            case 34525: {
                this.getIpv6Handler().handle(packet);
            }
        }
    }

    private final int readEthernetType(ByteBuf buffer) {
        int ethernetType = buffer.readUnsignedShort();
        return switch (ethernetType) {
            case 33024, 34984 -> {
                buffer.skipBytes(2);
                yield this.readEthernetType(buffer);
            }
            default -> ethernetType;
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/sip3/captain/ce/pipeline/EthernetHandler$Companion;", "", "()V", "TYPE_802_1_AD", "", "TYPE_802_1_Q", "TYPE_IPV4", "TYPE_IPV6", "sip3-captain-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

